/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.table;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class GPTable
extends JTable {
    public GPTable(TableModel model) {
        super(model);
        this.setShowGrid(true);
        this.setGridColor(Color.black);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setAutoResizeMode(4);
        this.addMouseListener(new MouseAdapter(){
            Point p = new Point();

            @Override
            public void mouseClicked(MouseEvent e) {
                this.p.x = e.getX();
                this.p.y = e.getY();
                int row = GPTable.this.rowAtPoint(this.p);
                int column = GPTable.this.columnAtPoint(this.p);
                if (row != -1 && column != -1) {
                    Object object = GPTable.this.getValueAt(row, column);
                }
            }
        });
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return realIndex >= 0 ? GPTable.this.getColumnName(realIndex) : null;
            }
        };
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object obj;
        String tip = null;
        Point p = event.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        if (hitColumnIndex != -1 && hitRowIndex != -1 && (obj = this.getValueAt(hitRowIndex, hitColumnIndex)) != null) {
            tip = obj.toString();
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }
}

