/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.MappingEtiology;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MGeneSet {
    private GeneSet mappedGeneSet;
    private MappingEtiology met;

    public MGeneSet(GeneSet sourceGeneSet, boolean maintainEtiology, Chip targetChip, Chip2ChipMapper mapper) throws Exception {
        if (sourceGeneSet == null) {
            throw new IllegalArgumentException("Param sourceGeneSet cannot be null");
        }
        if (targetChip == null) {
            throw new IllegalArgumentException("Param targetChip cannot be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Param mapper cannot be null");
        }
        HashSet<String> targets = new HashSet<String>();
        if (maintainEtiology) {
            this.met = new MappingEtiology(AuxUtils.getAuxNameOnlyNoHash(sourceGeneSet.getName()), targetChip.getName());
        }
        for (int i = 0; i < sourceGeneSet.getNumMembers(); ++i) {
            String sourceMember = sourceGeneSet.getMember(i);
            Set<String> target = mapper.map(sourceMember);
            if (target != null) {
                targets.addAll(target);
            }
            if (!maintainEtiology) continue;
            try {
                this.met.add(sourceMember, target);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.mappedGeneSet = new GeneSet(sourceGeneSet.getName(), Collections.unmodifiableSet(targets));
        if (maintainEtiology) {
            this.met.setImmutable();
        }
    }

    public GeneSet getMappedGeneSet(boolean simpleName) {
        return this.mappedGeneSet;
    }

    public MappingEtiology getEtiology() {
        return this.met;
    }
}

