/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.genepattern.uiutil.FTPFile;

public class ComparatorFactory {
    public static Comparator<PersistentObject> PERSISTENT_OBJECT_BY_NAME = new Comparator<PersistentObject>(){

        @Override
        public int compare(PersistentObject o1, PersistentObject o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    private ComparatorFactory() {
    }

    public static class FTPFileByVersionComparator
    implements Comparator<FTPFile> {
        private String highestVersionId;
        private DefaultArtifactVersion highestVersion = new DefaultArtifactVersion("v0.0");
        private final String preferredPrefix;

        public String getHighestVersionId() {
            return this.highestVersionId;
        }

        public FTPFileByVersionComparator() {
            this.preferredPrefix = null;
        }

        public FTPFileByVersionComparator(String preferredPrefix) {
            this.preferredPrefix = preferredPrefix;
        }

        @Override
        public int compare(FTPFile ftpFile1, FTPFile ftpFile2) {
            DefaultArtifactVersion version2;
            MSigDBVersion msigDBVersion1 = ftpFile1.getMSigDBVersion();
            MSigDBVersion msigDBVersion2 = ftpFile2.getMSigDBVersion();
            if (msigDBVersion1 == null) {
                return msigDBVersion2 == null ? 0 : -1;
            }
            if (msigDBVersion2 == null) {
                return 1;
            }
            DefaultArtifactVersion version1 = msigDBVersion1.getArtifactVersion();
            if (!version1.equals((Object)(version2 = msigDBVersion2.getArtifactVersion()))) {
                int compareTo = version2.compareTo((ArtifactVersion)version1);
                if (compareTo < 0) {
                    if (this.highestVersion.compareTo((ArtifactVersion)version1) < 0) {
                        this.highestVersion = version1;
                        this.highestVersionId = msigDBVersion1.getVersionString();
                    }
                } else if (this.highestVersion.compareTo((ArtifactVersion)version2) < 0) {
                    this.highestVersion = version2;
                    this.highestVersionId = msigDBVersion2.getVersionString();
                }
                return compareTo;
            }
            if (this.highestVersion.compareTo((ArtifactVersion)version1) < 0) {
                this.highestVersion = version1;
                this.highestVersionId = msigDBVersion1.getVersionString();
            }
            String s1 = ftpFile1.getName();
            String s2 = ftpFile2.getName();
            if (this.preferredPrefix != null) {
                boolean s1HasPP = s1.startsWith(this.preferredPrefix);
                boolean s2HasPP = s2.startsWith(this.preferredPrefix);
                if (s1HasPP && !s2HasPP) {
                    return -1;
                }
                if (!s1HasPP && s2HasPP) {
                    return 1;
                }
            }
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class ScoredDatasetScoreComparator
    implements Comparator<String> {
        final ScoredDataset fSds;

        public ScoredDatasetScoreComparator(ScoredDataset sds) {
            this.fSds = sds;
        }

        @Override
        public int compare(String pn1, String pn2) {
            int rank1 = this.fSds.getRank(pn1);
            int rank2 = this.fSds.getRank(pn2);
            if (rank1 == -1 || rank2 == -1) {
                throw new IllegalArgumentException("Specified label not in the sds: " + pn1 + " " + pn2);
            }
            return rank1 - rank2;
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class FileExtComparator
    implements Comparator<String> {
        @Override
        public int compare(String pn1, String pn2) {
            String ext1 = FilenameUtils.getExtension((String)pn1);
            String ext2 = FilenameUtils.getExtension((String)pn2);
            return ext1.compareTo(ext2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class PobComparator
    implements Comparator<PersistentObject> {
        @Override
        public int compare(PersistentObject pob1, PersistentObject pob2) {
            return pob1.getName().compareTo(pob2.getName());
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class EnrichmentResultByNESComparator
    implements Comparator<EnrichmentResult> {
        Order fOrder;
        final int byOrderLess;
        final int byOrderMore;

        public EnrichmentResultByNESComparator(Order order) {
            this.fOrder = order;
            this.byOrderLess = this.fOrder.isAscending() ? -1 : 1;
            this.byOrderMore = this.fOrder.isAscending() ? 1 : -1;
        }

        @Override
        public int compare(EnrichmentResult result1, EnrichmentResult result2) {
            if (result1 == null && result2 == null) {
                return 0;
            }
            if (result1 == null) {
                return this.byOrderLess;
            }
            if (result2 == null) {
                return this.byOrderMore;
            }
            float nes1 = result1.getScore().getNES();
            float nes2 = result2.getScore().getNES();
            boolean isNaN1 = Float.isNaN(nes1);
            boolean isNaN2 = Float.isNaN(nes2);
            if (isNaN1 && isNaN2) {
                return 0;
            }
            if (isNaN1) {
                return this.byOrderLess;
            }
            if (isNaN2) {
                return this.byOrderMore;
            }
            if (nes1 == nes2) {
                return 0;
            }
            if (nes1 < nes2) {
                return this.byOrderLess;
            }
            return this.byOrderMore;
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }
}

