/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ehcache;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.objectmatrix.stub.AbstractMapToTiledMatrix2DWrapper;
import org.ujmp.ehcache.EhcacheMap;

public class EhcacheTiledObjectMatrix2D
extends AbstractMapToTiledMatrix2DWrapper
implements Erasable,
Flushable,
Closeable {
    private static final long serialVersionUID = 4324063544046176423L;

    public EhcacheTiledObjectMatrix2D(long rows, long columns) throws IOException {
        super(new EhcacheMap<Coordinates, ObjectMatrix2D>(), rows, columns);
    }

    public EhcacheTiledObjectMatrix2D(Matrix source) throws IOException {
        super(new EhcacheMap<Coordinates, ObjectMatrix2D>(), source);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (long[] c : this.availableCoordinates()) {
            s.writeObject(Coordinates.wrap(c));
            s.writeObject(this.getObject(c));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            while (true) {
                Coordinates c = (Coordinates)s.readObject();
                Object o = s.readObject();
                this.setObject(o, c.getLongCoordinates());
            }
        }
        catch (OptionalDataException e) {
            return;
        }
    }

    public void erase() throws IOException {
        ((Erasable)((Object)this.getMap())).erase();
    }

    public void flush() throws IOException {
        ((Flushable)((Object)this.getMap())).flush();
    }

    public void close() throws IOException {
        ((Closeable)((Object)this.getMap())).close();
    }
}

