/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.matrix;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.listmatrix.AbstractListMatrix;
import org.ujmp.jdbc.autoclose.AutoOpenCloseConnection;
import org.ujmp.jdbc.util.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCCatalogMatrix
extends AbstractListMatrix<Matrix> {
    private static final long serialVersionUID = 8777880644085058629L;
    public static final String URL = "URL";
    public static final String DATABASENAME = "DatabaseName";
    public static final String SQLDIALECT = "SQLDialect";
    private transient Connection connection;

    public static JDBCCatalogMatrix connectToSQLite(File file) throws SQLException {
        return new JDBCCatalogMatrix("jdbc:sqlite:" + file.getAbsolutePath(), null, null, null);
    }

    protected JDBCCatalogMatrix(String url, String username, String password, String catalogName) throws SQLException {
        this(new AutoOpenCloseConnection(url, username, password), catalogName);
    }

    public JDBCCatalogMatrix(Connection connection, String catalogName) throws SQLException {
        this.connection = connection;
        String url = connection.getMetaData().getURL();
        this.setMetaData(URL, url);
        this.setMetaData(SQLDIALECT, (Object)SQLUtil.getSQLDialect(url));
        this.setMetaData(DATABASENAME, catalogName);
    }

    @Override
    public synchronized Matrix get(int index) {
        try {
            this.connection.setCatalog(this.getCatalogName());
            DatabaseMetaData meta = this.connection.getMetaData();
            ResultSet rs = meta.getTables(null, null, "%", null);
            int count = 0;
            String tableName = null;
            while (rs.next()) {
                if (count == index) {
                    tableName = rs.getString(3);
                    break;
                }
                ++count;
            }
            rs.close();
            DenseMatrix m = Matrix.Factory.zeros(10L, 10L);
            m.setLabel(tableName);
            return m;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCatalogName() {
        return this.getMetaDataString(DATABASENAME);
    }

    @Override
    public boolean addToList(Matrix t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToList(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix removeFromList(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix setToList(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        try {
            this.connection.setCatalog(this.getCatalogName());
            DatabaseMetaData meta = this.connection.getMetaData();
            ResultSet rs = meta.getTables(null, null, "%", null);
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            rs.close();
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

