/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.core.util.VerifyUtil;

public class JackcessDenseObjectMatrix2D
extends AbstractDenseObjectMatrix2D
implements Closeable {
    private static final long serialVersionUID = -6342663672866315180L;
    private final Database database;
    private final Table table;
    private List<? extends Column> columns = null;
    private Cursor cursor = null;
    private Integer curPos = null;

    public JackcessDenseObjectMatrix2D(File file, String tablename) throws IOException {
        super(0L, 0L);
        this.database = DatabaseBuilder.open((File)file);
        VerifyUtil.verifyNotNull(this.database, "database could not be opened");
        this.table = this.database.getTable(tablename);
        VerifyUtil.verifyNotNull(this.table, "table not found in database");
        this.columns = this.table.getColumns();
        this.cursor = CursorBuilder.createCursor((Table)this.table);
        for (int i = 0; i < this.columns.size(); ++i) {
            this.setColumnLabel(i, this.columns.get(i).getName());
        }
        this.setLabel(tablename);
    }

    public JackcessDenseObjectMatrix2D(File file, Matrix matrix) throws IOException {
        this(file, "ujmp-matrix", matrix);
    }

    public JackcessDenseObjectMatrix2D(File file, String tablename, Matrix matrix) throws IOException {
        super(matrix.getRowCount(), matrix.getColumnCount());
        try {
            this.database = DatabaseBuilder.create((Database.FileFormat)Database.FileFormat.V2010, (File)file);
            TableBuilder tb = new TableBuilder(tablename);
            int i = 0;
            while ((long)i < matrix.getColumnCount()) {
                ColumnBuilder cb = new ColumnBuilder("Column" + i);
                switch (matrix.getValueType()) {
                    case DOUBLE: {
                        cb.setSQLType(8);
                        break;
                    }
                    case INT: {
                        cb.setSQLType(4);
                        break;
                    }
                    default: {
                        cb.setSQLType(12);
                    }
                }
                tb.addColumn(cb.toColumn());
                ++i;
            }
            this.table = tb.toTable(this.database);
            int r = 0;
            while ((long)r < matrix.getRowCount()) {
                Object[] data = new Object[(int)matrix.getColumnCount()];
                int c = 0;
                while ((long)c < matrix.getColumnCount()) {
                    data[c] = matrix.getAsObject(r, c);
                    ++c;
                }
                this.table.addRow(data);
                ++r;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Object getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    public synchronized Object getObject(int row, int column) {
        if (this.columns == null || this.cursor == null) {
            return null;
        }
        try {
            Column c = this.columns.get(column);
            if (this.curPos == null) {
                this.cursor.reset();
                this.cursor.moveNextRows(row + 1);
            } else {
                int diff = row + 1 - this.curPos;
                if (diff > 0) {
                    this.cursor.moveNextRows(diff);
                } else if (diff < 0) {
                    this.cursor.movePreviousRows(-diff);
                }
            }
            this.curPos = row + 1;
            return this.cursor.getCurrentRowValue(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setObject(Object value, long row, long column) {
    }

    public void setObject(Object value, int row, int column) {
    }

    public long[] getSize() {
        this.size[0] = this.table.getRowCount();
        this.size[1] = this.table.getColumnCount();
        return this.size;
    }

    public void close() throws IOException {
        this.database.close();
    }
}

