/*
 * Decompiled with CFR 0.152.
 */
package xtools.munge;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.vdb.chip.Chip;
import java.util.List;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.ModeReqdParam;
import xtools.api.param.StringInputParam;

public class CollapseDataset
extends AbstractTool {
    private final ChipOptParam fChipParam = new ChipOptParam(true);
    private final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    private final ModeReqdParam fModeParam = new ModeReqdParam("mode", "Collapsing mode for probe sets => 1 gene", "Collapsing mode for probe sets => 1 gene", "Max_probe", new String[]{"Max_probe", "Median_of_probes", "Mean_of_probes", "Sum_of_probes", "Abs_max_of_probes", "Remap_only"});
    private final BooleanParam fIncludeOnlySymbols = new BooleanParam("include_only_symbols", "Omit features with no symbol match", "If there is no known gene symbol match for a probe set omit if from the collapsed dataset", true, false);
    private final StringInputParam fResultFileNameParam = new StringInputParam("out_file", "Result File Name", "Name for the resulting collapsed dataset.  The default is to use a name based on the original plus the collapsing mode", "", false);

    public CollapseDataset(Properties properties) {
        super.init(properties, "");
    }

    public CollapseDataset(Properties properties, String paramFilePath) {
        super.init(properties, paramFilePath);
    }

    public CollapseDataset(String[] args) {
        super.init(args);
    }

    public CollapseDataset() {
        this.declareParams();
    }

    @Override
    public String getName() {
        return "CollapseDataset";
    }

    @Override
    public void execute() throws Exception {
        this.startExec();
        Chip chip = this.fChipParam.getChip();
        Dataset ds = this.fDatasetParam.getDataset();
        DatasetGenerators.CollapsedDataset cds = new DatasetGenerators().collapse(ds, chip, this.fIncludeOnlySymbols.isTrue(), this.fModeParam.getStringIndexChoosen(), this.fResultFileNameParam.getValueStringRepresentation(true));
        List<String> warnings = ds.getWarnings();
        for (String warning : warnings) {
            this.fReport.addWarning(warning);
        }
        warnings = cds.symbolized.getWarnings();
        for (String warning : warnings) {
            this.fReport.addWarning(warning);
        }
        this.log.debug("# after collapsing: {}", (Object)cds.symbolized.getNumRow());
        this.fReport.savePage(cds.symbolized, true);
        this.fReport.savePageTsv(cds.makeEtiologySdf());
        this.doneExec();
    }

    @Override
    public String getDesc() {
        return "Collapse expression values from multiple probe sets of a gene to a single value";
    }

    @Override
    public ToolCategory getCategory() {
        return ToolCategory.DATASET;
    }

    @Override
    public void declareParams() {
        this.fParamSet.addParam(this.fChipParam);
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParam(this.fIncludeOnlySymbols);
        this.fParamSet.addParam(this.fModeParam);
        this.fParamSet.addParamAdv(this.fResultFileNameParam);
    }

    public static void main(String[] args) {
        CollapseDataset tool = new CollapseDataset(args);
        CollapseDataset.tool_main(tool);
    }
}

