/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.UIResource;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.PixelConverter;
import org.genepattern.heatmap.RowColorScheme;

public class HeatMapPanel
extends JPanel {
    public static int COLOR_RESPONSE_LOG = 0;
    public static int COLOR_RESPONSE_LINEAR = 1;
    public static int NORMALIZATION_ROW = 0;
    public static int NORMALIZATION_GLOBAL = 1;
    private IExpressionData data;
    int columnSize = 8;
    int rowSize = 8;
    private boolean drawGrid = true;
    private Color borderColor = Color.black;
    private ColorScheme colorConverter;
    private int normalization = NORMALIZATION_ROW;
    private boolean showToolTip = true;
    private PixelConverter pixelConverter;
    private PropertyChangeSupport changeSupport;
    private boolean upperTriangular = false;
    private boolean showNamesInToolTipText = true;
    private NumberFormat numberFormat;
    private ToolTipProvider toolTipProvider;

    public HeatMapPanel(IExpressionData data) {
        this(data, RowColorScheme.getDefaultColorMap());
    }

    public HeatMapPanel(IExpressionData data, Color[] colorMap) {
        this.data = data;
        this.colorConverter = RowColorScheme.getRowInstance(colorMap);
        this.colorConverter.setDataset(data);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.pixelConverter = new PixelConverter(this);
        this.pixelConverter.rowSize = this.rowSize;
        this.pixelConverter.columnSize = this.columnSize;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(4);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void setExpressionData(IExpressionData data) {
        this.data = data;
        this.colorConverter.setDataset(data);
        this.repaint();
    }

    public void setToolTipProvider(ToolTipProvider t) {
        this.toolTipProvider = t;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (!this.showToolTip) {
            return null;
        }
        int col = this.pixelConverter.columnAtPoint(e.getPoint());
        int row = this.pixelConverter.rowAtPoint(e.getPoint());
        if (col >= 0 && col < this.data.getColumnCount() && row >= 0 && row < this.data.getRowCount()) {
            if (this.toolTipProvider != null) {
                return this.toolTipProvider.getToolTipText(row, col);
            }
            String value = this.numberFormat.format(this.data.getValue(row, col));
            return this.showNamesInToolTipText ? "<html>" + value + "<br>" + this.data.getRowName(row) + "<br>" + this.data.getColumnName(col) : value;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        int y;
        super.paintComponent(g);
        int columns = this.data.getColumnCount();
        Rectangle bounds = g.getClipBounds();
        int left = 0;
        int right = columns;
        int top = 0;
        int bottom = this.data.getRowCount();
        if (bounds != null) {
            top = this.pixelConverter.getTopIndex(bounds.y);
            bottom = this.pixelConverter.getBottomIndex(bounds.y + bounds.height, this.data.getRowCount());
            left = this.pixelConverter.getLeftIndex(bounds.x);
            right = this.pixelConverter.getRightIndex(bounds.x + bounds.width, columns);
        }
        for (int row = top; row < bottom; ++row) {
            for (int column = left; column < right; ++column) {
                int x = column * this.columnSize + this.getInsets().left;
                y = row * this.rowSize + this.getInsets().top;
                if (this.upperTriangular && column < row) continue;
                g.setColor(this.colorConverter.getColor(row, column));
                g.fillRect(x, y, this.columnSize, this.rowSize);
            }
        }
        if (this.drawGrid) {
            g.setColor(this.borderColor);
            int leftx = left * this.columnSize + this.getInsets().left;
            int rightx = right * this.columnSize + this.getInsets().left;
            for (int row = top; row <= bottom; ++row) {
                y = row * this.rowSize + this.getInsets().top;
                if (this.upperTriangular) {
                    int leftDiag = (row - 1) * this.columnSize + this.getInsets().left;
                    g.drawLine(leftDiag, y, rightx, y);
                    continue;
                }
                g.drawLine(leftx, y, rightx, y);
            }
            int topy = this.getInsets().top + this.rowSize * top;
            int bottomy = this.getInsets().top + this.rowSize * bottom;
            for (int column = left; column <= right; ++column) {
                int x = column * this.columnSize + this.getInsets().left;
                if (this.upperTriangular) {
                    int bottomDiag = this.rowSize * (column + 1) + this.getInsets().top;
                    if (column == columns) {
                        bottomDiag -= this.rowSize;
                    }
                    g.drawLine(x, topy, x, bottomDiag);
                    continue;
                }
                g.drawLine(x, topy, x, bottomy);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    @Override
    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Border border = scrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane scrollPane;
        JViewport viewport;
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && ((viewport = (scrollPane = (JScrollPane)gp).getViewport()) == null || viewport.getView() != this)) {
            return;
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null && oldValue != null && !oldValue.equals(newValue)) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.columnSize * this.data.getColumnCount() + 1, this.rowSize * (this.data.getRowCount() + 1));
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int elementHeight) {
        this.pixelConverter.rowSize = this.rowSize = elementHeight;
        this.firePropertyChange("rowSize", new Integer(elementHeight), new Integer(this.rowSize));
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int elementWidth) {
        this.pixelConverter.columnSize = this.columnSize = elementWidth;
        this.firePropertyChange("columnSize", new Integer(elementWidth), new Integer(this.columnSize));
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        this.drawGrid = drawGrid;
    }

    public int getNormalization() {
        return this.normalization;
    }

    public void setNormalization(int normalization) {
        this.normalization = normalization;
        if (this.colorConverter instanceof RowColorScheme) {
            ((RowColorScheme)this.colorConverter).setGlobalScale(normalization == NORMALIZATION_GLOBAL);
        }
    }

    public void setColorConverter(ColorScheme colorConverter) {
        this.colorConverter = colorConverter;
        colorConverter.setDataset(this.data);
    }

    public ColorScheme getColorConverter() {
        return this.colorConverter;
    }

    public boolean isUpperTriangular() {
        return this.upperTriangular;
    }

    public void setUpperTriangular(boolean upperTriangular) {
        this.upperTriangular = upperTriangular;
    }

    public static interface ToolTipProvider {
        public String getToolTipText(int var1, int var2);
    }
}

