/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.matrix;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.MathUtil;

public class DoubleMatrix2D {
    private static final transient Logger klog = LoggerFactory.getLogger(DoubleMatrix2D.class);
    private final DenseDoubleMatrix2D matrix;

    public DoubleMatrix2D(double[][] data) {
        this.matrix = Matrix.Factory.linkToArray(data);
        this.fillInRows();
        this.fillInColumns();
    }

    public DoubleMatrix2D(double[][] data, String[] rowNames, String[] columnNames) {
        int rows = data.length;
        if (rows == 0) {
            throw new IllegalArgumentException("Number of rows must be greater than 0");
        }
        int columns = data[0].length;
        if (columns == 0) {
            throw new IllegalArgumentException("Number of columns must be greater than 0");
        }
        if (columnNames.length != columns) {
            throw new IllegalArgumentException("Length of column names must be equal to number of columns in data.");
        }
        if (rowNames.length != rows) {
            throw new IllegalArgumentException("Length of row names must be equal to number of rows in data.");
        }
        this.matrix = Matrix.Factory.linkToArray(data);
        this.setRowNames(Arrays.asList(rowNames));
        this.setColumnNames(Arrays.asList(columnNames));
    }

    private DoubleMatrix2D(DenseDoubleMatrix2D matrix) {
        this.matrix = matrix;
    }

    public DoubleMatrix2D slice(int[] rowIndices, int[] columnIndices) {
        int i;
        if (rowIndices == null) {
            rowIndices = new int[this.getRowCount()];
            i = this.getRowCount();
            while (--i >= 0) {
                rowIndices[i] = i;
            }
        }
        if (columnIndices == null) {
            columnIndices = new int[this.getColumnCount()];
            i = this.getColumnCount();
            while (--i >= 0) {
                columnIndices[i] = i;
            }
        }
        klog.info("About to slice...");
        long[] r = MathUtil.toLongArray((int[])rowIndices);
        long[] c = MathUtil.toLongArray((int[])columnIndices);
        DenseDoubleMatrix2D slice = (DenseDoubleMatrix2D)this.matrix.select(DenseDoubleMatrix2D.NEW, (long[][])new long[][]{r, c});
        return new DoubleMatrix2D(slice);
    }

    private void fillInRows() {
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String rowName = String.valueOf(i + 1);
            this.matrix.setRowLabel((long)i, (Object)rowName);
        }
    }

    private void fillInColumns() {
        int columns = this.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            String name = "X" + String.valueOf(i + 1);
            this.matrix.setColumnLabel((long)i, (Object)name);
        }
    }

    private void setRowNames(List s) {
        if (s.size() > this.getRowCount()) {
            throw new IllegalArgumentException("Invalid row names length. getRowCount():" + this.getRowCount() + " row names length:" + s.size());
        }
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            String rowName = (String)s.get(i);
            if (rowName == null) {
                throw new IllegalArgumentException("Null row names are not allowed.");
            }
            int rowForLabel = MathUtil.longToInt((long)this.matrix.getRowForLabel((Object)rowName));
            if (rowForLabel >= 0 && rowForLabel < size && rowForLabel != i) {
                throw new IllegalArgumentException("Duplicate row names are not allowed:" + rowName);
            }
            this.matrix.setRowLabel((long)i, (Object)rowName);
        }
    }

    private void setColumnNames(List s) {
        if (s.size() > this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column names length. getColumnCount():" + this.getColumnCount() + " column names length:" + s.size());
        }
        for (int i = 0; i < s.size(); ++i) {
            String name = (String)s.get(i);
            if (name == null) {
                throw new IllegalArgumentException("Null column names are not allowed.");
            }
            int columnForLabel = MathUtil.longToInt((long)this.matrix.getColumnForLabel((Object)name));
            if (columnForLabel >= 0 && columnForLabel != i) {
                throw new IllegalArgumentException("Duplicate column names are not allowed:" + name);
            }
            this.matrix.setColumnLabel((long)i, (Object)name);
        }
    }

    public int getRowIndex(String rowName) {
        return MathUtil.longToInt((long)this.matrix.getRowForLabel((Object)rowName));
    }

    public int getColumnIndex(String columnName) {
        return MathUtil.longToInt((long)this.matrix.getColumnForLabel((Object)columnName));
    }

    public double get(int row, int column) {
        return this.matrix.getDouble(row, column);
    }

    public String getRowName(int rowIndex) {
        return this.matrix.getRowLabel((long)rowIndex);
    }

    public String getColumnName(int columnIndex) {
        return this.matrix.getColumnLabel((long)columnIndex);
    }

    public int getRowCount() {
        return MathUtil.longToInt((long)this.matrix.getRowCount());
    }

    public int getColumnCount() {
        return MathUtil.longToInt((long)this.matrix.getColumnCount());
    }
}

