/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import au.com.pegasustech.demos.layout.SRLayout;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImplFromSampleNames;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.searchers.GeneSearchList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TemplateCreatorWidgets {

    public static class GenePhenotype
    extends JPanel {
        private GeneSearchList geneSearch = new GeneSearchList();
        private JComboBox cbDataset;
        private Template createdTemplate;

        public GenePhenotype() {
            this.geneSearch.getJList().setVisibleRowCount(50);
            this.geneSearch.getJList().setSelectionMode(0);
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.geneSearch.getComponent(), "Center");
            JPanel val = new JPanel(new BorderLayout());
            JButton bValidate = new JButton("Apply to dataset");
            bValidate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.createTemplate();
                }
            });
            val.add((Component)bValidate, "East");
            this.cbDataset = new JComboBox();
            this.cbDataset.setBorder(BorderFactory.createTitledBorder("Dataset"));
            GuiHelper.safeSelect(this.cbDataset);
            this.cbDataset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = cbDataset.getSelectedItem();
                    if (obj != null) {
                        geneSearch.setFeatures(((Dataset)obj).getRowNames());
                    }
                }
            });
            this.cbDataset.setEditable(false);
            ObjectBindery.bind(this.cbDataset, new Class[]{Dataset.class});
            val.add((Component)this.cbDataset, "Center");
            this.add((Component)val, "South");
        }

        private void createTemplate() {
            try {
                Object selectedItem = this.geneSearch.getJList().getSelectedValue();
                if (selectedItem == null) {
                    Application.getWindowManager().showMessage("First select a gene, then apply");
                    return;
                }
                Object obj = this.cbDataset.getSelectedItem();
                if (obj == null) {
                    Application.getWindowManager().showMessage("No dataset available. First import a dataset and then apply this phenotype");
                    return;
                }
                File out = Application.getVdbManager().getDefaultOutputDir();
                Dataset ds = (Dataset)obj;
                String geneName = selectedItem.toString();
                String tn = geneName + "_profile_in_" + ds.getName() + ".cls";
                File file = NamingConventions.createSafeFile(out, tn);
                this.createdTemplate = TemplateFactory.createContinuousTemplate(geneName, ds);
                ParserFactory.save(this.createdTemplate, file);
                Application.getWindowManager().showMessage("Successfully made template: " + this.createdTemplate.getName());
            }
            catch (Throwable t) {
                Application.getWindowManager().showError("Trouble making template", t);
            }
        }
    }

    public static class OnTheFlyFromSampleNames
    extends JPanel {
        private JTextArea taClassA;
        private JTextField tfClassA;
        private JTextArea taClassB;
        private JTextField tfClassB;
        private JComboBox cbDataset;
        private Template createdTemplate;

        public OnTheFlyFromSampleNames() {
            JPanel pan = new JPanel((LayoutManager)new SRLayout(2, 15));
            JPanel sub_a = new JPanel(new BorderLayout());
            sub_a.add((Component)new JLabel("Class A (sample names must match the dataset)"), "North");
            this.taClassA = new JTextArea(20, 10);
            this.taClassA.setBorder(BorderFactory.createTitledBorder("Samples for class A (one per line)"));
            sub_a.add((Component)new JScrollPane(this.taClassA), "Center");
            this.tfClassA = new JTextField("ClassA", 20);
            this.tfClassA.setBorder(BorderFactory.createTitledBorder("Enter a brief name for class A"));
            sub_a.add((Component)this.tfClassA, "South");
            this.taClassB = new JTextArea(20, 10);
            this.taClassB.setBorder(BorderFactory.createTitledBorder("Samples for class B (one per line)"));
            JPanel sub_b = new JPanel(new BorderLayout());
            sub_b.add((Component)new JLabel("Class B (and sample names cant be reused)"), "North");
            sub_b.add((Component)new JScrollPane(this.taClassB), "Center");
            this.tfClassB = new JTextField("ClassB", 20);
            this.tfClassB.setBorder(BorderFactory.createTitledBorder("Enter a brief name for class B"));
            sub_b.add((Component)this.tfClassB, "South");
            pan.add(sub_a);
            pan.add(sub_b);
            this.setLayout(new BorderLayout());
            this.add((Component)pan, "Center");
            JPanel val = new JPanel(new BorderLayout(10, 10));
            JButton bValidate = new JButton("Apply to dataset");
            bValidate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.createTemplate();
                }
            });
            val.add((Component)bValidate, "East");
            this.cbDataset = new JComboBox();
            this.cbDataset.setBorder(BorderFactory.createTitledBorder("Dataset"));
            this.cbDataset.setEditable(false);
            ObjectBindery.bind(this.cbDataset, new Class[]{Dataset.class});
            GuiHelper.safeSelect(this.cbDataset);
            val.add((Component)this.cbDataset, "Center");
            this.add((Component)val, "South");
        }

        private void createTemplate() {
            try {
                if (this.taClassA.getText().trim().length() == 0) {
                    Application.getWindowManager().showMessage("No sample names specified in class A");
                    return;
                }
                if (this.taClassB.getText().trim().length() == 0) {
                    Application.getWindowManager().showMessage("No sample names specified in class B");
                    return;
                }
                if (this.tfClassA.getText().trim().length() == 0) {
                    Application.getWindowManager().showMessage("Invalid (empty) name specified for class A");
                    return;
                }
                if (this.tfClassB.getText().trim().length() == 0) {
                    Application.getWindowManager().showMessage("Invalid (empty) name specified for class B");
                    return;
                }
                Object obj = this.cbDataset.getSelectedItem();
                if (obj == null) {
                    Application.getWindowManager().showMessage("No dataset available. First import a dataset and then apply this phenotype");
                    return;
                }
                File out = Application.getVdbManager().getDefaultOutputDir();
                String classAName = this.tfClassA.getText();
                String classBName = this.tfClassB.getText();
                String tn = classAName + "_vs_" + classBName + ".cls";
                File file = NamingConventions.createSafeFile(out, tn);
                String[] classASampleNames = ParseUtils.string2strings(this.taClassA.getText(), "\n\t");
                String[] classBSampleNames = ParseUtils.string2strings(this.taClassB.getText(), "\n\t");
                TemplateImplFromSampleNames tsn = new TemplateImplFromSampleNames(tn, classAName, classASampleNames, classBName, classBSampleNames);
                this.createdTemplate = tsn.createTemplate((Dataset)obj);
                ParserFactory.save(tsn, file);
                Application.getWindowManager().showMessage("Successfully made template: " + this.createdTemplate.getName());
            }
            catch (Throwable t) {
                Application.getWindowManager().showError("Trouble making template", t);
            }
        }
    }
}

