/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.FDistribution;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class OneWayANOVA
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private float alpha;
    private boolean usePerms;
    private int numPerms;
    private int correctionMethod;
    int[] groupAssignments;
    float currentP = 0.0f;
    int currentIndex = 0;
    double constant;
    AlgorithmEvent event;
    Vector fValuesVector = new Vector();
    Vector rawPValuesVector = new Vector();
    Vector adjPValuesVector = new Vector();
    Vector dfNumVector = new Vector();
    Vector dfDenomVector = new Vector();
    Vector ssGroupsVector = new Vector();
    Vector ssErrorVector = new Vector();
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        this.groupAssignments = algorithmData.getIntArray("group-assignments");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.usePerms = algorithmParameters.getBoolean("usePerms", false);
        this.numPerms = algorithmParameters.getInt("numPerms", 0);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n3 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.alpha = algorithmParameters.getFloat("alpha", 0.01f);
        this.correctionMethod = algorithmParameters.getInt("correction-method", 1);
        this.numGroups = algorithmParameters.getInt("numGroups", 3);
        this.getFDfSSValues();
        this.rawPValuesVector = !this.usePerms ? this.getRawPValuesFromFDist() : this.getRawPValsFromPerms();
        this.adjPValuesVector = this.getAdjPVals(this.rawPValuesVector, this.correctionMethod);
        Vector vector = new Vector();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        this.event = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        for (int i = 0; i < this.numGenes; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Finding significant genes: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            float f = ((Float)this.adjPValuesVector.get(i)).floatValue();
            if (f <= this.alpha) {
                vector2.add(new Integer(i));
                continue;
            }
            vector3.add(new Integer(i));
        }
        vector.add(vector2);
        vector.add(vector3);
        this.k = vector.size();
        FloatMatrix floatMatrix = new FloatMatrix(this.fValuesVector.size(), 1);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.rawPValuesVector.size(), 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.adjPValuesVector.size(), 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        for (n2 = 0; n2 < this.fValuesVector.size(); ++n2) {
            floatMatrix.A[n2][0] = ((Float)this.fValuesVector.get(n2)).floatValue();
        }
        for (n2 = 0; n2 < this.rawPValuesVector.size(); ++n2) {
            floatMatrix2.A[n2][0] = ((Float)this.rawPValuesVector.get(n2)).floatValue();
            floatMatrix3.A[n2][0] = ((Float)this.adjPValuesVector.get(n2)).floatValue();
        }
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            floatMatrix4.A[n2][0] = ((Integer)this.dfNumVector.get(n2)).floatValue();
            floatMatrix5.A[n2][0] = ((Integer)this.dfDenomVector.get(n2)).floatValue();
            if (floatMatrix4.A[n2][0] <= 0.0f) {
                floatMatrix4.A[n2][0] = Float.NaN;
            }
            if (!(floatMatrix5.A[n2][0] <= 0.0f)) continue;
            floatMatrix5.A[n2][0] = Float.NaN;
        }
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        for (n = 0; n < floatMatrix6.getRowDimension(); ++n) {
            floatMatrix6.A[n][0] = ((Double)this.ssGroupsVector.get(n)).floatValue();
            floatMatrix7.A[n][0] = ((Double)this.ssErrorVector.get(n)).floatValue();
        }
        this.clusters = new Vector[this.k];
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = (Vector)vector.get(n);
        }
        FloatMatrix floatMatrix8 = this.getMeans(this.clusters);
        FloatMatrix floatMatrix9 = this.getVariances(this.clusters, floatMatrix8);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n3, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix8);
        algorithmData2.addMatrix("clusters_variances", floatMatrix9);
        algorithmData2.addMatrix("rawPValues", floatMatrix2);
        algorithmData2.addMatrix("adjPValues", floatMatrix3);
        algorithmData2.addMatrix("fValues", floatMatrix);
        algorithmData2.addMatrix("dfNumMatrix", floatMatrix4);
        algorithmData2.addMatrix("dfDenomMatrix", floatMatrix5);
        algorithmData2.addMatrix("ssGroupsMatrix", floatMatrix6);
        algorithmData2.addMatrix("ssErrorMatrix", floatMatrix7);
        algorithmData2.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        algorithmData2.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private void getFDfSSValues() throws AlgorithmException {
        this.event = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        for (int i = 0; i < this.numGenes; ++i) {
            float f = 0.0f;
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Calculating F and df: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            float[] fArray = new float[this.numExps];
            int n = 0;
            for (int j = 0; j < this.numExps; ++j) {
                fArray[j] = this.expMatrix.A[i][j];
                if (Float.isNaN(fArray[j])) continue;
                ++n;
            }
            if (n == 0) {
                f = Float.NaN;
            }
            this.constant = this.getConstant(fArray);
            double d = this.getTotalSS(fArray);
            double d2 = this.getGroupsSS(fArray);
            double d3 = d - d2;
            if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
                f = Float.NaN;
            }
            int n2 = this.getDfNum(i);
            int n3 = this.getDfDenom(i);
            double d4 = d2 / (double)n2;
            double d5 = d3 / (double)n3;
            if (!Float.isNaN(f)) {
                double d6 = d4 / d5;
                f = (float)d6;
            }
            this.fValuesVector.add(new Float(f));
            this.dfNumVector.add(new Integer(n2));
            this.dfDenomVector.add(new Integer(n3));
            this.ssGroupsVector.add(new Double(d2));
            this.ssErrorVector.add(new Double(d3));
        }
    }

    private Vector getRawPValuesFromFDist() {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.numGenes; ++i) {
            double d = ((Float)this.fValuesVector.get(i)).doubleValue();
            int n = (Integer)this.dfNumVector.get(i);
            int n2 = (Integer)this.dfDenomVector.get(i);
            if (Double.isNaN(d) || n <= 0 || n2 <= 0) {
                vector.add(new Float(Float.NaN));
                continue;
            }
            FDistribution fDistribution = new FDistribution((double)n, (double)n2);
            double d2 = fDistribution.cumulative(d);
            double d3 = 1.0 - d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            vector.add(new Float(d3));
        }
        return vector;
    }

    private Vector getRawPValsFromPerms() throws AlgorithmException {
        int n;
        this.event = new AlgorithmEvent(this, 1, this.numPerms);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        float[] fArray = new float[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            fArray[i] = 0.0f;
        }
        float[] fArray2 = new float[this.fValuesVector.size()];
        for (int i = 0; i < this.fValuesVector.size(); ++i) {
            fArray2[i] = ((Float)this.fValuesVector.get(i)).floatValue();
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 0) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)vector.get(n);
        }
        for (n = 0; n < this.numPerms; ++n) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(n);
            this.event.setDescription("Permuting matrix: Current permutation = " + (n + 1));
            this.fireValueChanged(this.event);
            int[] nArray2 = this.getPermutedValues(this.numExps, nArray);
            FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray2);
            float[] fArray3 = this.getPermutedFVals(floatMatrix);
            for (int i = 0; i < this.numGenes; ++i) {
                if (!(fArray3[i] > fArray2[i])) continue;
                int n2 = i;
                fArray[n2] = fArray[n2] + 1.0f;
            }
        }
        for (n = 0; n < this.numGenes; ++n) {
            fArray[n] = Float.isNaN(fArray2[n]) ? Float.NaN : fArray[n] / (float)this.numPerms;
        }
        Vector<Float> vector2 = new Vector<Float>();
        for (int i = 0; i < fArray.length; ++i) {
            vector2.add(new Float(fArray[i]));
        }
        return vector2;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][nArray[j]];
            }
        }
        return floatMatrix2;
    }

    private float[] getPermutedFVals(FloatMatrix floatMatrix) {
        float[] fArray = new float[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            float f = 0.0f;
            float[] fArray2 = new float[this.numExps];
            int n = 0;
            for (int j = 0; j < this.numExps; ++j) {
                fArray2[j] = floatMatrix.A[i][j];
                if (Float.isNaN(fArray2[j])) continue;
                ++n;
            }
            if (n == 0) {
                f = Float.NaN;
            }
            this.constant = this.getConstant(fArray2);
            double d = this.getTotalSS(fArray2);
            double d2 = this.getGroupsSS(fArray2);
            double d3 = d - d2;
            if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
                f = Float.NaN;
            }
            int n2 = this.getDfNum(i, floatMatrix);
            int n3 = this.getDfDenom(i, floatMatrix);
            double d4 = d2 / (double)n2;
            double d5 = d3 / (double)n3;
            if (!Float.isNaN(f)) {
                double d6 = d4 / d5;
                f = (float)d6;
            }
            fArray[i] = f;
        }
        return fArray;
    }

    private int[] getPermutedValues(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[n];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        for (n2 = nArray3.length; n2 > 1; --n2) {
            Random random = new Random();
            int n3 = random.nextInt(n2 - 1);
            int n4 = nArray3[n3];
            nArray3[n3] = nArray3[n2 - 1];
            nArray3[n2 - 1] = n4;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[nArray[n2]] = nArray3[n2];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray2;
    }

    private Vector getAdjPVals(Vector vector, int n) throws AlgorithmException {
        this.event = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        Vector vector2 = new Vector();
        if (n == 1) {
            vector2 = (Vector)vector.clone();
        }
        if (n == 2) {
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Computing adjusted p-values: Current gene = " + (i + 1));
                this.fireValueChanged(this.event);
                float f = ((Float)vector.get(i)).floatValue();
                float f2 = f * (float)this.numGenes;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                vector2.add(new Float(f2));
            }
        }
        if (n == 3) {
            vector2 = this.getAdjBonfPVals(vector);
        }
        if (n == 9) {
            vector2 = this.getMaxTPVals();
        }
        return vector2;
    }

    private Vector getMaxTPVals() throws AlgorithmException {
        int n;
        int n2;
        double[] dArray = new double[this.numGenes];
        double[] dArray2 = new double[this.numGenes];
        int[] nArray = new int[this.numGenes];
        double[] dArray3 = new double[this.numGenes];
        double[][] dArray4 = new double[this.numPerms][this.numGenes];
        double[][] dArray5 = new double[this.numGenes][this.numPerms];
        this.event = new AlgorithmEvent(this, 1, this.numPerms);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = ((Float)this.fValuesVector.get(i)).doubleValue();
        }
        QSort qSort = new QSort(dArray, 2);
        dArray2 = qSort.getSortedDouble();
        nArray = qSort.getOrigIndx();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 0) continue;
            vector.add(new Integer(i));
        }
        int[] nArray2 = new int[vector.size()];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = (Integer)vector.get(n2);
        }
        for (n2 = 0; n2 < this.numPerms; ++n2) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(n2);
            this.event.setDescription("Permuting matrix: Current permutation = " + (n2 + 1));
            this.fireValueChanged(this.event);
            int[] nArray3 = this.getPermutedValues(this.numExps, nArray2);
            FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray3);
            float[] fArray = this.getPermutedFVals(floatMatrix);
            dArray5[this.numGenes - 1][n2] = Double.isNaN(fArray[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : (double)fArray[nArray[this.numGenes - 1]];
            for (int i = this.numGenes - 2; i >= 0; --i) {
                dArray5[i][n2] = Double.isNaN(fArray[nArray[i]]) ? dArray5[i + 1][n2] : Math.max(dArray5[i + 1][n2], (double)fArray[nArray[i]]);
            }
        }
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            int n3 = 0;
            for (int i = 0; i < this.numPerms; ++i) {
                if (!(dArray5[n2][i] >= dArray2[n2])) continue;
                ++n3;
            }
            dArray3[nArray[n2]] = (double)n3 / (double)this.numPerms;
        }
        n2 = 0;
        for (n = 0; n < this.numGenes; ++n) {
            if (!Double.isNaN(dArray[n])) continue;
            dArray3[n] = Double.NaN;
            ++n2;
        }
        for (n = 1; n < this.numGenes - n2; ++n) {
            dArray3[nArray[n]] = Math.max(dArray3[nArray[n]], dArray3[nArray[n - 1]]);
        }
        Vector<Float> vector2 = new Vector<Float>();
        for (int i = 0; i < dArray3.length; ++i) {
            vector2.add(new Float(dArray3[i]));
        }
        return vector2;
    }

    private Vector getAdjBonfPVals(Vector vector) {
        int n;
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)vector.get(i)).floatValue();
        }
        float[] fArray2 = new float[fArray.length];
        QSort qSort = new QSort(fArray, 1);
        float[] fArray3 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        int n2 = this.numGenes;
        fArray2[nArray[0]] = fArray3[0] * (float)n2;
        for (n = 1; n < this.numGenes; ++n) {
            if (fArray3[n - 1] < fArray3[n]) {
                --n2;
            }
            if (n2 <= 0) {
                n2 = 1;
            }
            fArray2[nArray[n]] = fArray3[n] * (float)n2;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (!(fArray2[n] > 1.0f)) continue;
            fArray2[n] = 1.0f;
        }
        Vector<Float> vector2 = new Vector<Float>();
        for (int i = 0; i < fArray2.length; ++i) {
            vector2.add(new Float(fArray2[i]));
        }
        return vector2;
    }

    private float[] getGene(int n) {
        float[] fArray = new float[this.expMatrix.getColumnDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        return fArray;
    }

    private int getDfNum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(this.expMatrix.A[n][i]) || this.groupAssignments[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return this.numGroups - 1;
    }

    private int getDfDenom(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(this.expMatrix.A[n][i]) || this.groupAssignments[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return n2 - this.numGroups;
    }

    private int getDfNum(int n, FloatMatrix floatMatrix) {
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(floatMatrix.A[n][i]) || this.groupAssignments[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return this.numGroups - 1;
    }

    private int getDfDenom(int n, FloatMatrix floatMatrix) {
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(floatMatrix.A[n][i]) || this.groupAssignments[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return n2 - this.numGroups;
    }

    private double getConstant(float[] fArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || this.groupAssignments[i] == 0) continue;
            d += (double)fArray[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double d2 = Math.pow(d, 2.0) / (double)n;
        return d2;
    }

    private double getTotalSS(float[] fArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || this.groupAssignments[i] == 0) continue;
            d += Math.pow(fArray[i], 2.0);
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return d -= this.constant;
    }

    private double getGroupsSS(float[] fArray) {
        float[][] fArrayArray = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            fArrayArray[i] = this.getGeneValuesForGroup(fArray, i + 1);
        }
        double[] dArray = new double[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            dArray[i] = this.getAvSquare(fArrayArray[i]);
        }
        double d = 0.0;
        for (int i = 0; i < this.numGroups; ++i) {
            d += dArray[i];
        }
        return d - this.constant;
    }

    private float[] getGeneGroupMeans(int n) {
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        float[][] fArrayArray = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            fArrayArray[i] = this.getGeneValuesForGroup(fArray, i + 1);
        }
        float[] fArray2 = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            fArray2[i] = this.getMean(fArrayArray[i]);
        }
        return fArray2;
    }

    private float[] getGeneGroupSDs(int n) {
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        float[][] fArrayArray = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            fArrayArray[i] = this.getGeneValuesForGroup(fArray, i + 1);
        }
        float[] fArray2 = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            fArray2[i] = this.getStdDev(fArrayArray[i]);
        }
        return fArray2;
    }

    private float[] getGeneValuesForGroup(float[] fArray, int n) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != n) continue;
            vector.add(new Float(fArray[i]));
        }
        float[] fArray2 = new float[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fArray2[i] = ((Float)vector.get(i)).floatValue();
        }
        return fArray2;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            floatMatrix.A[i] = this.getGeneGroupMeans(i);
        }
        return floatMatrix;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            floatMatrix.A[i] = this.getGeneGroupSDs(i);
        }
        return floatMatrix;
    }

    private double getAvSquare(float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            d2 += (double)fArray[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        d = Math.pow(d2, 2.0) / (double)n;
        return d;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f2 = f / (float)n;
        if (Float.isInfinite(f2)) {
            return Float.NaN;
        }
        return f2;
    }

    private float getStdDev(float[] fArray) {
        float f = this.getMean(fArray);
        int n = 0;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float f3 = f2 / (float)(n - 1);
        if (Float.isInfinite(f3)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(f3);
    }
}

